package com.digiwin.athena.semc.dto.fineReport;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

/**
 * 查询帆软报表列表请求对象
 *
 * @author sunqgz
 * @since 2025-08-12
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryFineReportListReq implements Serializable {

    private static final long serialVersionUID = 3385258192227121295L;

    /**
     * 设备类型，1:PC 2:移动，不传表示全部
     */
    @Range(min = 1, max = 2, message = "the deviceType is illegal")
    private Integer deviceType;

    /**
     * 是否标记当前登录用户有权限查看的报表  false：否 true：是
     */
    private Boolean displayPermissionFlag;

    /**
     * 权限对象id（即组织id、角色id、用户id），当传入该参数，则忽略displayPermissionFlag，优先标记该权限对象有权限查看的报表
     */
    private String authBizId;
}