package com.digiwin.athena.semc.dto.fineReport;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 查询帆软报表列表请求对象
 *
 * @author sunqgz
 * @since 2025-08-14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryFineReportUrlReq implements Serializable {

    private static final long serialVersionUID = 6470726982234147196L;

    /**
     * 设备类型，1:PC端 2:移动端
     */
    @NotNull(message = "the deviceType cannot be null")
    @Range(min = 1, max = 2, message = "the deviceType is illegal")
    private Integer deviceType;

    /**
     * 报表id
     */
    @NotBlank(message = "the reportId cannot be null")
    private String reportId;

    /**
     * 报表路径
     */
    private String path;
}