package com.digiwin.athena.semc.dto.fineReport;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 帆软报表权限表 请求入参
 *
 * @author sunqgz
 * @since 2025-08-12
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveFineReportAuthReq implements Serializable {

    private static final long serialVersionUID = -7209096900792938754L;

    /**
     * 权限对象sid，例：组织sid、角色sid、用户sid、部门sid
     */
    @NotNull(message = "authId cannot be null")
    private Long authId;

    /**
     * 权限对象id，例：组织id、角色id、用户id、部门id
     */
    @NotBlank(message = "authBizId cannot be null")
    private String authBizId;

    /**
     * 权限对象名称
     */
    @NotBlank(message = "authName cannot be null")
    private String authName;

    /**
     * 权限类型：1.组织 2.角色 3.用户 4.部门
     */
    @NotNull(message = "authType cannot be null")
    @Range(min = 1, max = 4, message = "authType is illegality")
    private Integer authType;

    /**
     * 全部标识 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "the allAuthFlag is illegal")
    private Integer allAuthFlag;

    /**
     * 帆软报表id列表,allAuthFlag=1时该字段传空
     */
    private List<String> reportIdList;
}