package com.digiwin.athena.semc.dto.fineReport;

import com.digiwin.athena.semc.entity.fineReport.FineReportUserMapping;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 新增/修改租户的帆软参数配置
 *
 * @author sunqgz
 * @since 2025-08-11
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = FineReportUserMapping.class)
public class SaveFineReportUserMappingConfigReq implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 雅典娜用户账号
     */
    @NotBlank(message = "the userId cannot be null")
    private String userId;

    /**
     * 雅典娜用户名称
     */
    private String userName;

    /**
     * 帆软用户账号
     */
    @NotBlank(message = "the frUserId cannot be null")
    private String frUserId;

    /**
     * 帆软用户名称
     */
    @NotBlank(message = "the frUserId cannot be null")
    private String frUserName;

    /**
     * 帆软用户密码
     */
    @NotBlank(message = "the frUserId cannot be null")
    private String frUserPwd;

    /**
     * 帆软用户邮箱
     */
    @Email(message = "the frUserEmail is not a valid email")
    private String frUserEmail;

    /**
     * 帆软用户手机号
     */
    @Size(max = 11, message = "the frUserMobile cannot be more than 11 characters")
    private String frUserMobile;

    /**
     * 租户id
     */
    private String tenantId;
}