package com.digiwin.athena.semc.dto.homepage;

import lombok.*;

import java.io.Serializable;

/**
 * @description 首页tbb消息通知列表
 * @author: sungqz
 * @create: 2023-8-23
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class AdvertisementDTO implements Serializable {

    private static final long serialVersionUID = -7613933053020695424L;

    /**
     * 广告id
     */
    private String id;

    /**
     * 广告标题
     */
    private String adTitle;

    /**
     * 广告投放区域
     */
    private String adLaunchArea;

    /**
     * 广告描述
     */
    private String adDesc;

    /**
     * 广告链接
     */
    private String adUrl;

    /**
     * 广告图片链接
     */
    private String adImgUrl;

    /**
     * 广告状态
     */
    private String adStatus;

    /**
     * 广告有效天数
     */
    private String effectiveDuration;

    /**
     * 广告生效日期
     */
    private String effectiveTime;

    /**
     * 失效时间
     */
    private String lostEffectiveTime;

    /**
     * 创建者id
     */
    private String creatorId;

    /**
     * 创建者名称
     */
    private String creatorName;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 产品线
     */
    private String productCode;

    /**
     * 创建者部门
     */
    private String departmentCode;

    /**
     * 服务中心
     */
    private String serviceRegion;

    /**
     * 服务中心名称
     */
    private String regionDisplayName;

    /**
     * 时机点 nextLogin：下次登录
     */
    private String triggerPoint;

    /**
     * 重要性 important:重要 unimportant:不重要
     */
    private String triggerEvent;

    /**
     * 读取状态 true:已读 false:未读
     */
    private Boolean readStatus;

    /**
     * 剩余时间
     */
    private String remainingTime;
}