package com.digiwin.athena.semc.dto.homepage;

import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 首页搜索响应实体
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class HomeSearchDTO implements Comparable<HomeSearchDTO> {
    private static final long serialVersionUID = -6727599977825574618L;

    /**
     *任务/项目ID/新闻公告ID
     */
    private String id;

    /**
     * 0：项目卡 1：任务卡 2：发起项目 3：基础资料录入 4：报表 5：友情链接应用 6：其他 7:三方待办  8:三方报表
     */
    private Integer type;

    /**
     * 名称
     */
    private String name;

    /**
     * 任务/项目状态
     */
    private String state;

    /**
     * 任务/项目：ID 基础资料/报表/发起项目：定义编码
     */
    private String code;


    /**
     *
     */
    private String engineType;

    /**
     * 任务/项目定义编码
     */
    private String projectDefCode;

    /**
     *
     */
    private String taskDefCode;

    /**
     *
     */
    private String taskDefPattern;

    /**
     *
     */
    private String taskDefCategory;

    /**
     *应用sid
     */
    private String appId;

    /**
     *授权回调地址
     */
    private String callBackUrl;

    private Integer protocolType;

    private String applicationAppId;

    /**
     *应用类型 稳态、敏态
     */
    private String systemType;

    /**
     *
     */
    private Long systemId;

    /**
     *开始时间，格式：yyyy-MM-dd HH:mm:ss
     */
    private String  startTime;

    /**
     *结束时间，格式：yyyy-MM-dd HH:mm:ss
     */
    private String  endTime;


    /**
     * appToken
     */
    private String appToken;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    private Integer userBindFlag;

    /**
     * category
     */
    private String category;

    /**
     * appCode
     */
    private String appCode;

    /**
     * appCode
     */
    private Boolean ifCustom;

    /**
     * copyCode
     */
    private String copyCode;


    /**
     * 是否需要实时获取sso地址，0：不需要；1：需要
     */
    private int isNeedSsoUrl;


    @Override
    public int compareTo(@NotNull HomeSearchDTO o) {
        return this.name.compareTo(o.getName());
    }
}
