package com.digiwin.athena.semc.dto.homepage;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * tbb消息通知读取广告
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReadAdvertisementReq implements Serializable  {

    private static final long serialVersionUID = -8115841900212392405L;

    /**
     * 广告id
     */
    @NotNull(message = "{NotNull.ReadAdvertisementReq.adId}")
    private Long adId;

    /**
     * 广告标题
     */
    @NotBlank(message = "{NotBlank.ReadAdvertisementReq.adTitle}")
    private String adTitle;

    /**
     * 重要性 0:不重要 1:重要
     */
    @NotNull(message = "{NotNull.ReadAdvertisementReq.importanceFlag}")
    @Range(min = 0, max = 1, message = "{Range.ReadAdvertisementReq.importanceFlag}")
    private Integer importanceFlag;

    /**
     * 浏览平台 entrance：智能入口 tbb：tbb
     */
    @NotBlank(message = "{NotBlank.ReadAdvertisementReq.readPlatform}")
    private String readPlatform;
}