package com.digiwin.athena.semc.dto.homepage;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

/**
 * 租户保存使用的门户类型
 *
 * @author sungqz
 * @since 2024-05-24
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveTenantPortalReq implements Serializable  {

    private static final long serialVersionUID = 8193174761814850831L;

    /**
     * 切换的门户类型 0:极简门户 1:传统门户
     */
    @Range(min = 0, max = 1, message = "门户类型标识不正确")
    private Integer portalType;

    /**
     * 是否使用最近一次的门户 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "是否使用最近一次的门户标识不正确")
    private Integer useLatestFlag;
}
