package com.digiwin.athena.semc.dto.homepage;

import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 版更信息
 * @createDate: 2023/2/13 9:42
 * @author: sunyfa
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UpgradeInfoDTO implements Serializable {
    private static final long serialVersionUID = -6727599977825574618L;

    /**
     * 版更提醒ID
     */
    private String sid;

    /**
     * 应用标识（平台/应用）
     */
    private String code;

    /**
     * 应用标识名称（平台/应用）
     */
    private String name;

    /**
     * 版本号
     */
    private String deployNote;

    /**
     * 版更时间
     */
    private String updateTime;

    /**
     * 重要等级 目前约定0 否 1 是 后续越大越重要
     */
    private int infoLevel;

    /**
     * 标题
     */
    private String title;

    /**
     * 版更详情列表
     */
    private List<DetailDTO> details;

    @Data
    public static class DetailDTO {
        /**
         * 版更内容标题
         */
        private String title;

        /**
         * 版更内容详情
         */
        private List<ContentDTO> content;
    }

    @Data
    public static class ContentDTO {
        /**
         * 文字说明
         */
        private String text;

        /**
         * 视频链接
         */
        private String videoUrl;

        /**
         * 图片链接
         */
        private String imgUrl;

        /**
         * 附件链接
         */
        private String attachmentUrl;
    }

}
