package com.digiwin.athena.semc.dto.menu;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 保存模板权限对象
 *
 * @author sunqgz
 * @since 2024-05-29
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryMenuTemplateReq implements Serializable {

    private static final long serialVersionUID = 8581585880286525422L;

    /**
     * 菜单模板名称
     */
    private String templateName;

    /**
     * 菜单模板状态 0:未发布 1:已发布
     */
    @Range(min = 0, max = 1, message = "菜单模板状态标识不合法")
    private Integer templateStatus;

    /**
     * 门户id
     */
    private Long portalId;

    /**
     * 当前页
     */
    @Min(value = 1, message = "the pageNum can not less than 1")
    private Integer pageNum = 1;

    /**
     * 每页数量
     */
    @Min(value = 1, message = "the pageSize can not less than 1")
    private Integer pageSize = 10;

}