package com.digiwin.athena.semc.dto.menu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.digiwin.athena.semc.vo.menu.CustomizedMenuWorkResp;
import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 保存菜单结构对象
 *
 * @author sunqgz
 * @since 2023-11-10
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveMenuReq implements Serializable {
    private static final long serialVersionUID = 2938621469132089762L;

    /**
     * 主键id
     */
    private Long templateId;

    /**
     * 模板名称
     */
    @NotBlank(message = "templateName cannot be null")
    @Size(max = 30, message = "The length of the templateName cannot exceed 30")
    private String templateName;

    /**
     * 模板名称_繁体
     */
    private String templateNameTw;

    /**
     * 模板描述
     */
    @Size(max = 100, message = "The length of the templateDesc cannot exceed 100")
    private String templateDesc;

    /**
     * 是否展示系统菜单 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "systemMenuFlag is illegal")
    private Integer systemMenuFlag;

    /**
     * 模板状态 0:未发布 1:已发布
     */
    @Range(min = 0, max = 1, message = "templateStatus is illegal")
    private Integer templateStatus;

    /**
     * 菜单树列表
     */
    private List<CustomizedMenuWorkResp> menuList;
}