package com.digiwin.athena.semc.dto.menu;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 保存模板权限对象
 *
 * @author sunqgz
 * @since 2023-11-09
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveTemplateAuthReq implements Serializable {
    private static final long serialVersionUID = 2938621469132089762L;
    /**
     * 模板id
     */
    @NotNull(message = "templateId cannot be null")
    private Long templateId;

    /**
     * 组织对象
     */
    @Valid
    private List<AuthDTO> orgList;

    /**
     * 角色对象
     */
    @Valid
    private List<AuthDTO> roleList;

    /**
     * 用户对象
     */
    @Valid
    private List<AuthDTO> userList;

    @Data
    public static class AuthDTO {
        /**
         * 权限对象id
         */
        @NotNull(message = "authId cannot be null")
        private Long authId;

        /**
         * 权限对象名称
         */
        @NotBlank(message = "authName cannot be null")
        private String authName;

        /**
         * 权限对象类型：1.组织 2.角色 3.用户
         */
        @NotNull(message = "authType cannot be null")
        @Range(min = 1, max = 3, message = "authType is illegality")
        private Integer authType;
    }
}