package com.digiwin.athena.semc.dto.menu;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 更新菜单模板状态
 *
 * @author sunqgz
 * @since 2024-05-30
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UpdateMenuTemplateReq implements Serializable {

    private static final long serialVersionUID = -7328736342215318690L;

    /**
     * 菜单模板主键id列表
     */
    private List<Long> idList;

    /**
     * 菜单模板状态 0:未发布 1:已发布
     */
    @NotNull(message = "菜单模板状态标识不能为空")
    @Range(min = 0, max = 1, message = "菜单模板状态标识不合法")
    private Integer templateStatus;
}