package com.digiwin.athena.semc.dto.menu.manage;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import java.io.Serializable;

/**
 * 查询基础菜单列表 请求入参
 *
 * @author sunqgz
 * @since 2024-09-30
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryMenuListReq implements Serializable {

    private static final long serialVersionUID = -3752598465378188873L;

    /**
     * 菜单类型 1:菜单 2:外链 3:iframe
     */
    @Range(min = 1, max = 2, message = "the menuType is illegal")
    private Integer menuType;

    /**
     * 菜单显示名称
     */
    private String menuName;

    /**
     * 是否可见，控制菜单是否在前端显示 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "the visibleFlag is illegal")
    private Integer visibleFlag;

    /**
     * 是否禁用，控制菜单是否可以点击 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "the visibleFlag is illegal")
    private Integer disabledFlag;

    /**
     * 所属环境标识 0:全部 1:云上 2:下地
     */
    @Range(min = 0, max = 2, message = "the visibleFlag is illegal")
    private Integer belongingEnvironmentFlag;
}