package com.digiwin.athena.semc.dto.menu.manage;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 管理后台保存菜单权限 请求入参
 *
 * @author sungqz
 * @since 2024-08-27
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveMenuAuthReq implements Serializable {

    private static final long serialVersionUID = -7775442112519972219L;

    /**
     * 菜单标识列表，当allMenuAuthFlag=1时，该字段为空
     */
    private List<String> menuKeyList;

    /**
     * 全员可见标识 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "the allMenuAuthFlag is illegal")
    private Integer allMenuAuthFlag;

    /**
     * 权限对象id
     */
    @NotNull(message = "{NotNull.BizObjAuthRelVo.authId}")
    private Long authId;

    /**
     * 权限类型：1.组织 2.角色 3.用户 5.部门
     */
    @NotNull(message = "{NotNull.BizObjAuthRelVo.authType}")
    private Integer authType;

    /**
     * 权限对象名称
     */
    @NotBlank(message = "{NotBlank.BizObjAuthRelVo.authName}")
    private String authName;

}