package com.digiwin.athena.semc.dto.message;

import com.digiwin.athena.semc.entity.message.EmailCompanyMapping;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * @author CR-7
 * create: 2024-05-14 11:23
 * Description:
 */
@Data
@AutoMapper(target = EmailCompanyMapping.class)
public class EmailCompanyMappingSaveOrUpdateReq {


    /**
     * 主键id
     */
    private Long id;

    /**
     * 公司名称
     */
    @NotBlank(message = "公司名称不可为空")
    @Size(max = 50,message = "公司名称请在50个字符以内")
    private String companyName;

    /**
     * 邮箱后缀
     */
    @NotBlank(message = "邮箱后缀不可为空")
    @Size(max = 50,message = "邮箱后缀请在50个字符以内")
    private String emailSuffix;

    /**
     * corpid
     */
    @NotBlank(message = "corpid不可为空")
    @Size(max = 100,message = "corpid请在100个字符以内")
    private String corpId;

    /**
     *  corpsecret
     */
    @NotBlank(message = "corpsecret不可为空")
    @Size(max = 100,message = "corpsecret请在100个字符以内")
    private String corpSecret;
}
