package com.digiwin.athena.semc.dto.message;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;


/**
 * 查询各个渠道列表 请求对象
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryTemplateListReq implements Serializable  {

    private static final long serialVersionUID = -45743256054146251L;

    /**
     * 渠道标识 email:邮件 sms:短信 wecom:企微 dingTalk:钉钉
     */
    @NotBlank(message = "the channelFlag can not be null")
    private String channelFlag;

    /**
     * 渠道名称过滤关键字
     */
    private String nameCondition;

    /**
     * 模板状态 0:停用 1:启用
     */
    @Range(min = 0, max = 1, message = "the status is illegal")
    private Integer status;

    /**
     * 租户id，传则查询该租户下的数据，不传取token所属租户
     */
    private String tenantId;

    /**
     * 事件id，过滤条件
     */
    private String eventId;

    /**
     * 模板备注，查询条件
     */
    private String remark;
}