package com.digiwin.athena.semc.dto.message;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;


/**
 * 查询模板关联人员 返回对象
 *
 * @author sungqz
 * @since 2024-01-09
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryTemplateRelResp implements Serializable  {

    private static final long serialVersionUID = -5742006372977782276L;

    /**
     * 收件人列表
     */
    private List<RelPersonDTO> contactList;

    /**
     * 抄送人列表
     */
    private List<RelPersonDTO> ccContactList;

    /**
     * 密送人列表
     */
    private List<RelPersonDTO> bccContactList;

    @Data
    public static class RelPersonDTO {
        /**
         * 主键id
         */
        private Long id;

        /**
         * 收件人，邮箱/手机号/用户id
         */
        private String value;

        /**
         * 语系
         */
        private String language;
    }
}