package com.digiwin.athena.semc.dto.message;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 查询异构系统的消息配置 请求入参
 * @createDate: 2024/3/4
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryThirdMessageConfigReq implements Serializable {

    private static final long serialVersionUID = -5356807581272114609L;

    /**
     * 应用主键id
     */
    private String appPrimaryId;

    /**
     * 有效状态 0:无效 1:有效
     */
    @Range(min = 0, max = 1, message = "the status is illegal")
    private Integer validStatus;

    /**
     * 数据获取方式 1:应用推送数据 2:拉取应用数据
     */
    @Range(min = 1, max = 2, message = "the dataGetType is illegal")
    private Integer dataGetType;

    /**
     * 当前页
     */
    @Min(value = 1, message = "the pageNum can not less than 1")
    private Integer pageNum = 1;

    /**
     * 每页数量
     */
    @Min(value = 1, message = "the pageSize can not less than 1")
    private Integer pageSize = 10;

    /**
     * 应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    private Integer appSource;
}