package com.digiwin.athena.semc.dto.message;

import lombok.*;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 查询异构系统的消息列表
 * @createDate: 2024/3/4
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryThirdMessageListReq implements Serializable {

    private static final long serialVersionUID = -7876763923064354223L;

    /**
     * 查询关键字
     */
    private String key;

    /**
     * 当前页
     */
    @NotNull(message = "the pageNum cannot be null")
    @Min(value = 1, message = "the pageNum can not less than 1")
    private Integer pageNum;

    /**
     * 每页数量
     */
    @NotNull(message = "the pageSize cannot be null")
    @Min(value = 1, message = "the pageSize can not less than 1")
    private Integer pageSize;

    /**
     * 查询的开始时间
     */
    private String startTimeStr;

    /**
     * 查询的结束时间
     */
    private String endTimeStr;

    /**
     * 消息状态，消息状态，0：未读，1：已读，全部：不传
     */
    private Integer state;

    /**
     * 应用id，sso配置中的appId值
     */
    private String appId;

    /**
     * 消息分类code
     */
    private String messageTypeCode;

    /**
     * 读取状态 0：全部 1：已读 2：未读
     */
    private Integer readFlag;

    /**
     * 0 pc 1 mobile
     */
    private Integer clientType;

}