package com.digiwin.athena.semc.dto.message;

import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @description: 接收异构系统推送的消息 请求入参
 * @createDate: 2024/3/6
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ReadThirdMessageReq implements Serializable {

    private static final long serialVersionUID = 4387618216538753674L;

    /**
     * 消息id
     */
    @NotBlank(message = "the messageId can not be empty")
    private String messageId;

    /**
     * 消息来源，即应用code
     */
    @NotBlank(message = "the messageAppCode can not be null")
    private String messageAppCode;

    /**
     * 应用id
     */
    @NotBlank(message = "the messageAppId can not be null")
    private String messageAppId;
}