package com.digiwin.athena.semc.dto.message;

import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 接收异构系统推送的消息 请求入参
 * @createDate: 2024/3/6
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ReceiveThirdMessageReq implements Serializable {

    private static final long serialVersionUID = -2377099628914986203L;

    /**
     *appId
     */
    @NotBlank(message = "the appid can not be null")
    private String appId;

    /**
     * 应用code
     */
    @NotBlank(message = "the appCode can not be null")
    private String appCode;

    /**
     * 消息列表
     */
    @NotEmpty(message = "the messageList can not be empty")
    @Size(max = 2000, message = "the length of messageList can not over 2000")
    private List<ThirdMessageInfo> messageList;

    /**
     * 发送渠道，逗号分割，如：wecom,dingding
     */
    private String sendChannel;
}