package com.digiwin.athena.semc.dto.message;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;


/**
 * 保存黑白名单 请求对象
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SaveBlackWhiteReq implements Serializable {

    private static final long serialVersionUID = -3575332385623629518L;

    /**
     * 名单类型 0:黑名单 1:白名单
     */
    @NotNull(message = "the type can not be null")
    @Range(min = 0, max = 1, message = "the type is illegal")
    private Integer type;

    /**
     * 用户列表
     */
    private List<UserDTO> userList;

    @Data
    public static class UserDTO {

        /**
         * 主键id
         */
        private Long id;

        /**
         * 用户sid
         */
        @NotNull(message = "the userSid can not be null")
        private String userSid;

        /**
         * 用户id
         */
        @NotNull(message = "the userId can not be null")
        private String userId;

        /**
         * 用户名
         */
        @NotNull(message = "the userName can not be null")
        private String userName;
    }
}