package com.digiwin.athena.semc.dto.message;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;


/**
 * 保存模板 请求对象
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SaveTemplateReq implements Serializable  {

    private static final long serialVersionUID = -3575332385623629518L;

    /**
     * 模板主键id
     */
    private Long templateId;

    /**
     * 渠道标识 email：邮箱 sms：短信 wecom：企微 dingTalk：钉钉
     */
    @NotBlank(message = "the channelFlag can not be null")
    private String channelFlag;

    /**
     * 事件id
     */
    @NotBlank(message = "the eventId can not be null")
    private String eventId;

    /**
     * 模板状态 0:停用 1:启用
     */
    @Range(min = 0, max = 1, message = "the status is illegal")
    private Integer status;

    /**
     * 模板备注，om平台事件备注
     */
    @Size(max = 200, message = "the length of remark can not over 200")
    private String remark;
}