package com.digiwin.athena.semc.dto.message;

import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * @description: 添加异构系统的消息配置 请求入参
 * @createDate: 2024/3/4
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = ThirdMessageConfig.class)
public class SaveThirdMessageConfigReq implements Serializable {

    private static final long serialVersionUID = 371803316807554629L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 应用主键id
     */
    @NotBlank(message = "the appPrimaryId cannot be null")
    private String appPrimaryId;

    /**
     * 应用code
     */
    @NotBlank(message = "the appCode cannot be null")
    private String appCode;

    /**
     * 应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    @NotNull(message = "the appSource cannot be null")
    @Range(min = 1, max = 4, message = "the appSource is illegal")
    private Integer appSource;

    /**
     * 应用注册时生成的appId
     */
    private String applicationAppId;

    /**
     * 配置描述
     */
    @Length(max = 200, message = "the length of configDesc cannot over 200")
    private String configDesc;

    /**
     * 有效状态 0:无效 1:有效
     */
    @NotNull(message = "the validStatus cannot be null")
    @Range(min = 0, max = 1, message = "the validStatus is illegal")
    private Integer validStatus;

   /**
     * 数据获取方式 1:应用推送数据 2:拉取应用数据
     */
    @NotNull(message = "the dataGetType cannot be null")
    @Range(min = 1, max = 2, message = "the dataGetType is illegal")
    private Integer dataGetType;

    /**
     * 拉取数据频率,单位秒 当dataGetType=2该字段必填
     */
    private Integer pullPeriod;

    /**
     * 应用接入模式 0:混合云 1:非混合云 当dataGetType=2该字段必填
     */
    @Range(min = 0, max = 1, message = "the appAccessModel is illegal")
    private Integer appAccessModel;

    /**
     * 地中台产品名称 当appAccessModel=0或者appAccessModel=1&&appType=2该字段必填
     */
    private String middleSystemName;

    /**
     * 地中台产品uid 当appAccessModel=0或者appAccessModel=1&&appType=2该字段必填
     */
    private String middleSystemUid;

    /**
     * 域名 当appAccessModel=1&&appType=1该字段必填
     */
    private String domain;

    /**
     * 发送渠道，逗号分割，如：wecom,dingding
     */
    private String sendChannel;
}