package com.digiwin.athena.semc.dto.message;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;


/**
 * 查询模板关联人员 请求对象
 *
 * @author sungqz
 * @since 2024-01-09
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TemplateRelReq implements Serializable {

    private static final long serialVersionUID = 3913014576542020870L;

    /**
     * 模板主键id
     */
    private Long templateId;

    /**
     * 渠道标识 email：邮箱 sms：短信 wecom：企微 dingTalk：钉钉
     */
    @NotBlank(message = "the channelFlag can not be null")
    private String channelFlag;

    /**
     * 事件id
     */
    @NotBlank(message = "the eventId can not be null")
    private String eventId;

    /**
     * 语系
     */
    private String language;

    /**
     * 收件人类型 1：收件人 2：抄送人 3：密送人，channelFlag为email时必传
     */
    @Range(min = 1, max = 3, message = "the emailType is illegal")
    private Integer emailType;

    /**
     * 邮箱/手机号/用户id 新增人员传
     */
    @Size(max = 1000, message = "the number of person can not over 1000")
    private List<String> contactList;

    /**
     * 收件人邮箱或手机号或用户id 主键id 删除人员传
     */
    private Long id;

    /**
     * 租户id
     */
    private String tenantId;
}