package com.digiwin.athena.semc.dto.message;

import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.proxy.iam.service.model.AppUserDTO;
import lombok.*;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @description: 查询异构系统的消息列表
 * @createDate: 2024/3/4
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ThirdMessageListResp implements Serializable {

    private static final long serialVersionUID = -7876763923064354223L;

    /**
     * 查询当前租户的sso配置应用
     */
    private List<AppLinkDTO> appLinkDTOList;

    /**
     * 查询当前鼎捷云用户id在各个应用下归户的三方用户id
     */
    private  List<AppUserDTO> verifyUserList;

    /**
     * 查询当前租户消息列表
     */
    private List<ThirdMessageInfo> messageInfoList;
}