package com.digiwin.athena.semc.dto.mobile;

import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumn;

import org.hibernate.validator.constraints.Length;

import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@AutoMapper(target = MobileApplicatonColumn.class)
public class ApplicationColumnReq {

    private Long id;

    /**
     * 上级id
     */
    private Long parentId;

    /**
     * 名称
     */
    @Length(max = 8,min = 0,message = "名称最大长度为8")
    private String name;

    /**
     * 状态：0：停运、1：启用
     */
    private Integer status;

    /**
     * 是否展示名称
     */
    private Integer isNameShow;

    /**
     * 自定义应用集合
     */
    private List<SaveAppcationReq> customApplication;

}
