package com.digiwin.athena.semc.dto.mobile;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import java.util.List;

/**
 * Created by changcong 21064
 * Date 2025/9/15 16:41
 * Description
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ApplicationColumnReqNew {
    private Long id;

    /**
     * 上级id
     */
    private Long parentId;

    /**
     * 名称
     */
    @Length(max = 8,min = 0,message = "名称最大长度为8")
    private String name;

    /**
     * 状态：0：停运、1：启用
     */
    private Integer status;

    /**
     * 是否展示名称
     */
    private Integer isNameShow;

    /**
     * 自定义应用集合
     */
    private List<SaveAppcationReqNew> customApplication;
}
