package com.digiwin.athena.semc.dto.mobile;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 查询移动端数据源配置列表 请求入参
 * @createDate: 2024/9/3
 * @author: qutong
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class CustomApplicationsListPageReq implements Serializable {

    private static final long serialVersionUID = -4266141308223406275L;

    /**
     * 名称
     */
    private String name;

    /**
     * 状态 0-未启用 1-已启用
     */
    @Range(min = 0, max = 2, message = "the status is illegal")
    private Integer status;

    /**
     * 类型 1-租户应用 2-平台应用
     */
    @Range(min = 0, max = 2, message = "the type is illegal")
    private Integer type;
    /**
     * 分类id
     */
    private List<Long> classificationIdList;

    /**
     * 作业code
     */
    private List<String> workCodeIdList;

    /**
     * 应用id
     */
    private String primaryId;

    /**
     * 数据源类型
     */
    private Integer dataSource;

    /**
     * 当前页
     */
    @Min(value = 1, message = "the pageNum can not less than 1")
    private Integer pageNum = 1;

    /**
     * 每页数量
     */
    @Min(value = 1, message = "the pageSize can not less than 1")
    private Integer pageSize = 10;
}
