package com.digiwin.athena.semc.dto.mobile;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
* 	 移动门户中的轮播图
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

public class MobilePortalContentCarousel implements Serializable {

    /**
     * 轮播图高度模式（ 0:默认、1：低、2：高、3：自定义）
     */
    private Integer heightModel;


    /**
     *  背景色
     */
    private String backgroundColor;

    /**
     *  边距，0：无边距 ；1：有边距
     */
    private Integer paddingFlag;


    /**
     *  高度
     */
    private Integer height;

    /**
     * 轮播图的图片集合
     */
    private List<MobilePortalContentCarouselImage> imageList;
}
