package com.digiwin.athena.semc.dto.mobile;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* 	 移动门户中的公告
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

public class MobilePortalContentNews  implements Serializable {

    /**
     * 公告样式（0：有图、1：无图）
     */
    private Integer newsModel;

    /**
     *  是否显示发布时间（0：否、1：是）
     */
    private Integer publishTimeFlag;

    /**
     * 是否显示阅读数量（0：否、1：是）
     */
    private Integer readNumFlag;

    /**
     * 公告类型id，0表示全部公告
     */
    private String newsTypeIdStr;

    /**
     * 公告类型id，0表示全部公告
     */
    private Integer newsTypeId;

    /**
     * 二级公告类型id，0表示全部公告
     */
    private Integer childrenNewsTypeId;

    /**
     * 公告显示数量
     */
    private Integer newsCount;


    /**
     * 是否显示点赞数量（0：否（默认）、1：是）
     */
    private Integer newsLikeCountFlag;
}
