package com.digiwin.athena.semc.dto.mobile;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
* 	 图片组件-热区信息
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

public class MobilePortalHotZoneReqDTO implements Serializable {

    /**
     * 跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告 5、公告类型_0表示全部公告）
     */
    private Integer jumpType;

    /**
     *  跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者 公告ID 或者公告类型ID）
     */
    private String jumpTarget;


    /**
     * 自定义应用id
     */
    private Long  customApplicationId;

    /**
     *  热区坐标
     */
    private List<Double> coordinate;


}
