package com.digiwin.athena.semc.dto.mobile;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
* 	 标题组件信息
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

public class MobilePortalTitleInfoReqDTO implements Serializable {

    /**
     * 背景色
     */
    private String backgroundColor;

    /**
     * 展示图标（0：不展示；1：展示）
     */
    private Integer iconFlag;

    /**
     *  图标样式（0：色块、1：图标）
     */
    private Integer iconStyle;

    /**
     *  色块
     */
    private String iconColor;


    /**
     *  图片类型（0：模板库选择、1：本地上传）
     */
    private Integer iconType;


    /**
     *  图标相对地址或者文件全量地址
     */
    private String iconUrl;


    /**
     *  图标或者图片文件ID
     */
    private String icon;


    /**
     *  主标题文字
     */
    private String mainTitleName;


    /**
     *  主标题颜色
     */
    private String mainTitleColor;


    /**
     *  副标题文字
     */
    private String subTitleName;


    /**
     *  副标题颜色
     */
    private String subTitleColor;


    /**
     *  显示链接（0：不展示；1：展示）
     */
    private Integer linkFlag;

    /**
     *  链接文字
     */
    private String linkName;

    /**
     *  链接颜色
     */
    private String linkColor;

    /**
     *  跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告 5、公告类型_0表示全部公告）
     */
    private Integer jumpType;


    /**
     *  跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者 公告ID 或者公告类型ID）
     */
    private String jumpTarget;


    /**
     *  应用/作业Id
     */
    private Long customApplicationId;

}
