package com.digiwin.athena.semc.dto.mobile;

import com.digiwin.athena.semc.common.Constants;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by changcong 21064
 * Date 2025/9/15 16:39
 * Description
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveAppcationReqNew implements Serializable {
    /**
     * 主键id
     */
    private String id;

    /**
     * 名称
     */
    @NotBlank(message = "名称必填")
    @Length(max = 50, message = "名称长度不能超过20")
    private String name;

    /**
     * 图标
     */
    private String icon;

    /**
     * 图标类型
     */
    private Integer iconType;

    /**
     * sso应用主键id
     */
    private String applicationPrimaryId;

    /**
     * sso应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    private Integer applicationSource;

    /**
     * 类型id
     */
    @NotNull(message = "类型不能为空")
    private Integer type;

    /**
     * 分类id
     */
    @NotNull(message = "分类不能为空")
    private Long classificationId;


    /**
     * 备注
     */
    @Length(max = 100, message = "备注长度不能超过100")
    private String remarks;

    /**
     * 作业代码
     */
    private String workCode;

    /**
     * 是否自定义作业  0：不需要；1：需要
     */
    private Integer isJob;

    /**
     * 回调地址
     */
    @Length(max = 500, message = "回调地址长度不能超过500")
    private String callBackUrl;

    /**
     * 状态：0-未启用；1-已启用
     */
    @Range(min = 0, max = 2, message = "状态不合法")
    private Integer status = Constants.MobileDatasourceInfoStatusEnum.UNUSABLE.getFlag();

    /**
     * 应用配置
     */
    private String applicationConfig;

    /**
     * 特殊标识：1-绿色智机 2-每刻
     */
    private Integer specialSign;

    private Integer source;

    /**
     * 模组id
     */
    private String moduleId;
}
