package com.digiwin.athena.semc.dto.mobile;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 更新数据状态
 * @createDate: 2024/9/3
 * @author: qutong
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UpdateAppcationConfigReq implements Serializable {

    private static final long serialVersionUID = -5089380165003428500L;

    /**
     * 主键id列表
     */
    @NotNull(message = "the id can not be null")
    private Long id;

    /**
     * iam关联商品id
     */
    @NotNull(message = "the iamApplicationId can not be null")
    private String iamApplicationId;

    /**
     * iam关联模组id
     */
    @NotNull(message = "the iamModuleId can not be null")
    private String iamModuleId;


    private String iamWorkId;
}
