package com.digiwin.athena.semc.dto.mobile;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 更新数据状态
 * @createDate: 2024/9/3
 * @author: qutong
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UpdateAppcationStatusReq implements Serializable {

    private static final long serialVersionUID = -5089380165003428500L;

    /**
     * 主键id列表
     */
    @NotEmpty(message = "the idList can not be empty")
    private List<Long> idList;

    /**
     * 状态 0:未启用 1:已启用
     */
    @NotNull(message = "the status can not be null")
    @Range(min = 0, max = 1, message = "the status is illegal")
    private Integer status;
}
