package com.digiwin.athena.semc.dto.mobile;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 校验用户自定义应用权限
 *
 * @author sungqz
 * @since 2024-12-27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ValidMobileAppAuthReqDTO implements Serializable {

    private static final long serialVersionUID = 8125089434964410922L;

    /**
     * 自定义应用id列表
     */
    @NotEmpty(message = "param is missing")
    private List<Long> customApplicationIdList;
}

