package com.digiwin.athena.semc.dto.mobile;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 校验用户自定义应用权限
 *
 * @author sungqz
 * @since 2024-12-27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class ValidMobileAppAuthRespDTO implements Serializable {

    private static final long serialVersionUID = -3603581331706442579L;

    /**
     * 自定义应用id
     */
    private Long customApplicationId;

    /**
     * 是否有权限 false：无 true：有
     */
    private Boolean authFlag = Boolean.FALSE;
}

