package com.digiwin.athena.semc.dto.news;

import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 公告id请求入参
 *
 * @author sunqgz
 * @since 2024-05-21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class AnnouncementIdReq implements Serializable {

    private static final long serialVersionUID = 2128817326090501511L;

    /**
     * 主键id
     */
    @NotNull(message = "主键id不能为空")
    private Long id;

    /**
     * 是否置顶 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "是否置顶标识不合法")
    private Integer toppedFlag;

    /**
     * 三方公告id
     */
    private String thirdNewsId;

    /**
     * 三方应用id
     */
    private String thirdAppId;

    /**
     * 三方应用code
     */
    private String thirdAppCode;
}

