package com.digiwin.athena.semc.dto.news;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 查询公告类型列表 请求入参
 *
 * @author sunqgz
 * @since 2024-05-21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryAnnouncementTypeReq implements Serializable {

    private static final long serialVersionUID = 5488061255665957170L;

    /**
     * 公告类型id（查公告列表时，不需要传递）
     */
    private Long newsTypeId;

    /**
     * 是否查询公告类型当前用户有权限的公告数（true查询，false和空不查询）
     */
    private Boolean queryAuthNewsCount;

    /**
     * 是否只查询一级公告类型 false：否 true：是
     */
    private Boolean onlyFirstFlag = Boolean.FALSE;

    /**
     * 是否只查询有权限的公告类型 false：否 true：是
     */
    private Boolean onlyAuthFlag = Boolean.FALSE;
}

