package com.digiwin.athena.semc.dto.news;

import org.hibernate.validator.constraints.Range;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 查询移动端用户公告 请求入参
 *
 * @author sunqgz
 * @since 2024-10-28
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryMobileNewsListPageReq implements Serializable {

    private static final long serialVersionUID = -6997413038121204708L;

    /**
     * 排序字段 1:综合排序 2:按发布时间排序 3：按阅读数排序，4：发布时间+点赞+收藏排序
     */
    @NotNull(message = "sortType can not be null")
    @Range(min = 1, max = 4, message = "sortType is illegal")
    private Integer sortType;

    /**
     * 排序规则 desc:倒序 asc:正序
     */
    private String orderByRule;

    /**
     * 公告类型id
     */
    private Long newsTypeId;

    /**
     * 发布时间 开始
     */
    private String effectiveTimeStart;

    /**
     * 发布时间 结束
     */
    private String effectiveTimeEnd;

    /**
     * 有无附件标识 true:有 false:无
     */
    private Boolean attachmentFlag = null;

    /**
     * 当前页
     */
    @Min(value = 1, message = "the pageNum can not less than 1")
    private Integer pageNum = 1;

    /**
     * 每页数量
     */
    @Min(value = 1, message = "the pageSize can not less than 1")
    private Integer pageSize = 10;

    /**
     * 公告类型id集合（末位分类集合）
     */
    private List<Long> newsTypeIdList;

    /**
     * 搜索关键字
     */
    private String keyword;

}