package com.digiwin.athena.semc.dto.news;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 查询公告列表 请求入参
 * @createDate: 2024/5/13
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class QueryNewsListPageReq implements Serializable {

    private static final long serialVersionUID = -4266141308223406275L;

    /**
     * 公告标题
     */
    private String newsTitle;

    /**
     * 公告状态 0:未发布 1:已发布 2:已失效 3:待生效(该状态在代码中体现)
     */
    @Range(min = 0, max = 3, message = "the newsStatus is illegal")
    private Integer newsStatus;

    /**
     * 公告来源 0：一方 1：三方
     */
    @Range(min = 0, max = 1, message = "the newsSource is illegal")
    private Integer newsSource;

    /**
     * 公告渠道标识 0:全部 1:Web工作台 2:移动工作台
     */
    @Range(min = 0, max = 2, message = "the newsChannel is illegal")
    private Integer newsChannel;

    /**
     * 公告类型id列表，只传末级公告类型id
     */
    private List<Long> newsTypeIdList;

    /**
     * 生效时间 开始
     */
    private String effectiveTimeStart;

    /**
     * 生效时间 结束
     */
    private String effectiveTimeEnd;

    /**
     * 截止时间 开始
     */
    private String endTimeStart;

    /**
     * 截止时间 结束
     */
    private String endTimeEnd;

    /**
     * 创建时间 开始
     */
    private String createTimeStart;

    /**
     * 创建时间 结束
     */
    private String createTimeEnd;

    /**
     * 来源系统应用code
     */
    private String appSourceCode;

    /**
     * 当前页
     */
    @Min(value = 1, message = "the pageNum can not less than 1")
    private Integer pageNum = 1;

    /**
     * 每页数量
     */
    @Min(value = 1, message = "the pageSize can not less than 1")
    private Integer pageSize = 10;

    /**
     * 公告渠道标识 0:全部 1:Web工作台 2:移动工作台
     */
    private List<Integer> newsChannelList;
}