package com.digiwin.athena.semc.dto.news;

import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.vo.auth.AuthVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 保存公告请求入参
 *
 * @author sunqgz
 * @since 2024-05-14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveAnnouncementReq implements Serializable {

    private static final long serialVersionUID = -5596953843864864289L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 公告标题
     */
    @NotBlank(message = "公告标题必填")
    @Length(max = 50, message = "公告标题长度不能超过50")
    private String newsTitle;

    /**
     * 公告类型id
     */
    @NotNull(message = "公告类型不能为空")
    private Long newsTypeId;

    /**
     * 父级公告类型id，一级公告类的父级公告类型id为0
     */
    @NotNull(message = "父级公告类型id不能为空")
    @Range(min = 0, message = "父级公告类型id不合法")
    private Long parentNewsTypeId;

    /**
     * 是否发送工作提醒 0：否 1：是
     */
    @Range(min = 0, max = 1, message = "是否发送工作提醒标识不合法")
    private Integer noticeFlag;

    /**
     * 公告生效时间类型 0:立即生效 1:定时生效
     */
    @Range(min = 0, max = 1, message = "公告生效时间类型不合法")
    private Integer newsEffectiveFlag;

    /**
     * 公告生效时间，默认是当前时间
     */
    private String newsEffectiveTime;

    /**
     * 公告截止时间
     */
    @NotBlank(message = "公告截止时间不能为空")
    private String newsEndTime;

    /**
     * 公告渠道标识 0:全部 1:Web工作台 2:移动工作台
     */
    @Range(min = 0, max = 2, message = "公告渠道标识不合法")
    private Integer newsChannel;

    /**
     * 全员可见 0:否 1:是
     */
    private Integer allAuthFlag;

    /**
     * 授权组织
     */
    private List<AuthVO> orgList;

    /**
     * 授权角色
     */
    private List<AuthVO> roleList;

    /**
     * 授权部门
     */
    private List<AuthVO> deptList;

    /**
     * 授权用户
     */
    private List<AuthVO> userList;


    /**
     * 授权外部用户
     */
    private List<AuthVO> externalUserList;

    /**
     * 公告摘要
     */
    private String summary;

    /**
     * 封面图默认icon
     */
    private String defaultImageIcon;

    /**
     * 封面图文件id
     */
    private String coverImageId;

    /**
     * 公告正文
     */
    @NotBlank(message = "公告正文不能为空")
    private String newsContent;

    /**
     * 附件id列表
     */
    private List<String> fileIdList;

    /**
     * 公告状态 0:未发布 1:已发布 2:已失效
     */
    @Range(min = 0, max = 2, message = "公告状态不合法")
    private Integer newsStatus = Constants.NewsAnnouncementStatusEnum.UNPUBLISHED.getFlag();

    /**
     * 发布人类型，1（无）， 2（发布人姓名） 3（发布人角色）
     */
    @NotNull(message = "发布人类型不能为空")
    private Integer publishType;

    /**
     * 发布人id（当publishType为3时必填）
     */
    private String publishId;


    /**
     * 发布人姓名
     */
    private String publishName;

}

