package com.digiwin.athena.semc.dto.news;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 公告权限
 * @createDate: 2024/5/13
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveNewsAuthReq implements Serializable {

    private static final long serialVersionUID = 7194115365882931528L;

    /**
     * 公告id
     */
    @NotNull(message = "{NotNull.Folder.id}")
    private Long newsId;

    /**
     * 全员可见 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "the allAuthFlag is illegal")
    private Integer allAuthFlag;

    /**
     * 权限对象id
     */
    private Long authId;

    /**
     * 权限类型：1.组织 2.角色 3.用户 4.外部用户 5.部门
     */
    @Range(min = 1, max = 5, message = "the authType is illegal")
    private Integer authType;

    /**
     * 权限对象名称
     */
    private String authName;
}