package com.digiwin.athena.semc.dto.news;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 公告类型权限表 请求入参
 *
 * @author sunqgz
 * @since 2025-01-14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class SaveNewsTypeAuthReq implements Serializable {

    private static final long serialVersionUID = -6081643754638365147L;

    /**
     * 权限对象id
     */
    @NotNull(message = "authId cannot be null")
    private Long authId;

    /**
     * 权限对象名称
     */
    @NotBlank(message = "authName cannot be null")
    private String authName;

    /**
     * 权限类型：1.组织 2.角色 3.用户 4.外部用户 5.部门
     */
    @NotNull(message = "authType cannot be null")
    @Range(min = 1, max = 5, message = "authType is illegality")
    private Integer authType;

    /**
     * 全部类型标识 0:否 1:是
     */
    @Range(min = 0, max = 1, message = "the allNewsTypeFlag is illegal")
    private Integer allNewsTypeFlag;

    /**
     * 公告类型id列表,allNewsTypeFlag=1时该字段传空
     */
    private List<Long> newsTypeIdList;
}