package com.digiwin.athena.semc.dto.news;

import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.*;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 新闻公告类型表 新增/编辑请求实体类
 *
 * @author sungqz
 * @since 2025-1-13
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@AutoMapper(target = NewsAnnouncementType.class)
public class SaveNewsTypeReqDTO implements Serializable {

    private static final long serialVersionUID = -9178643502246774477L;

    /**
     * 公告类型id
     */
    private Long id;

    /**
     * 公告类型标题
     */
    @NotBlank(message = "the name cannot be null")
    @Length(max = 8, message = "the length of name cannot over 8")
    private String name;

    /**
     * 公告类型层级
     */
    @Range(min = 1, max = 2, message = "level is illegal")
    private Integer level;

    /**
     * 公告类型顺序
     */
    @NotNull(message = "menuType can not be null")
    @Range(min = 1, max = 99999, message = "menuType is illegal")
    private Integer sort;

    /**
     * 父类型id
     */
    @NotNull(message = "parentId can not be null")
    @Range(min = 0, message = "menuType is illegal")
    private Long parentId;

    /**
     * 公告类型说明
     */
    @Length(max = 50, message = "the length of description cannot over 50")
    private String description;
}

