package com.digiwin.athena.semc.dto.news;

import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.vo.auth.AuthVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ThirdNewsAnnouncementReq {
    private static final long serialVersionUID = -5596953843864864289L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 三方公告id
     */
    @NotNull(message = "三方公告id不能为空")
    private String thirdNewsId;

    /**
     * 公告标题
     */
    @NotBlank(message = "公告标题必填")
    @Length(max = 50, message = "公告标题长度不能超过50")
    private String newsTitle;

    /**
     * 公告类型id
     */
    @Range(min = 1, max = 4, message = "公告其他类型暂不支持")
    @NotNull(message = "公告类型不能为空")
    private Long newsTypeId;

    /**
     * 公告截止时间
     */
    private String newsEndTime;


    /**
     * 授权用户
     */
    @Size(min = 1,max = 100,message = "必须要传入通知人员，最多可传100人")
    private List<String> userIds;

    /**
     * 公告摘要
     */
    private String summary;

    /**
     * 公告状态 0:未发布 1:已发布 2:已失效
     */
    @Range(min = 0, max = 1, message = "公告状态不合法")
    private Integer newsStatus = Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag();

    /**
     * 0:一方来源  1:三方来源
     */
    private Integer resourceType;

    /**
     * 三方域名
     */
    private String url;

    /**
     * 三方图片url
     */
    private String thirdImgUrl;

    /**
     * 三方公告详情网页（包含正文，详情等）
     */
    private String thirdNewsHtml;

    /**
     * 注册应用时生成的appId
     */
    private String applicationAppId;

    /**
     * 消息来源应用名称
     */
    private String messageAppName;

    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 协议类型 1、oauth2.0 2、cas
     */
    private Integer protocolType;

    /**
     * appToken
     */
    private String appToken;

}
