package com.digiwin.athena.semc.dto.news;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ThirdNewsReq {

    /**
     * 应用code，即SSO配置-B/S手工配置或者C/S手工配置中的应用ID
     * AES加密后传输，例：原appCode值是“SMES”，AES加密后值是“misg3Gko1xZFx8w==”
     */
    @NotEmpty
    private String appCode;

    /**
     * sso配置中的appId
     */
    @NotEmpty
    private String appId;

    /**
     * 消息集合，最大支持1000
     */
    @Valid
    @Size(min = 1,max = 500,message = "单次最少传送1条公告,最多只能传送500条公告")
    private List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs;
}
