package com.digiwin.athena.semc.dto.news;

import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @description: 更新公告状态
 * @createDate: 2024/5/13
 * @author: sungqz
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class UpdateNewsStatusReq implements Serializable {

    private static final long serialVersionUID = -5089380165003428500L;

    /**
     * 主键id列表
     */
    @NotEmpty(message = "the idList can not be empty")
    private List<Long> idList;

    /**
     * 公告状态 0:未发布 1:已发布 2:已失效
     */
    @NotNull(message = "the newsStatus can not be null")
    @Range(min = 0, max = 1, message = "the newsStatus is illegal")
    private Integer newsStatus;
}